﻿using VA.TMP.Integration.VIMT.Messages.VirtualMeetingRoom;
using VA.TMP.Integration.VIMT.VirtualMeetingRoom.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.VirtualMeetingRoom.PipelineSteps.Create
{
    /// <summary>
    /// Create Response step.
    /// </summary>
    public class CreateResponseStep : FilterBase<VirtualMeetingRoomCreateStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(VirtualMeetingRoomCreateStateObject state)
        {
            if (state.UseFakeResponse)
            {
                state.VirtualMeetingRoomCreateResponseMessage = new VirtualMeetingRoomCreateResponseMessage
                {
                    ExceptionMessage = "*****THIS IS FAKE DATA. VMR NOT CREATED*****",
                    ExceptionOccured = false,
                    MeetingRoomName = state.MeetingRoomName,
                    PatientUrl = state.PatientUrl,
                    ProviderUrl = state.ProviderUrl,
                    PatientPin = state.PatientPin,
                    ProviderPin = state.ProviderPin,
                    AppointmentId = state.CorrelationId,
                    DialingAlias = string.Format("{0}{1}", state.VirtualMeetingRoom, state.VirtualMeetingRoomSuffix),
                    MiscData = string.Format("hostDialUrl={0};guestDialUrl={1};", state.ProviderUrl, state.PatientUrl),
                    SerializedInstance = state.SerializedVirtualMeetingRoom
                };
            }
            else
            {
                state.VirtualMeetingRoomCreateResponseMessage = state.ExceptionOccured
                ? new VirtualMeetingRoomCreateResponseMessage { ExceptionOccured = true, ExceptionMessage = state.ExceptionMessage }
                : new VirtualMeetingRoomCreateResponseMessage
                {
                    ExceptionMessage = string.Empty,
                    ExceptionOccured = false,
                    MeetingRoomName = state.MeetingRoomName,
                    PatientUrl = state.PatientUrl,
                    ProviderUrl = state.ProviderUrl,
                    PatientPin = state.PatientPin,
                    ProviderPin = state.ProviderPin,
                    AppointmentId = state.CorrelationId,
                    DialingAlias = state.DialingAlias,
                    MiscData = state.MiscDataForResponse,
                    SerializedInstance = state.SerializedVirtualMeetingRoom
                };
            }
        }
    }
}